
/*
	Stempora Web Framework
	Copyright (c) 2002-2018 Stempora. 
	All rights reserved.
		web:  www.stempora.com
		mail: support@stempora.com				
*/


var STBModuleDataForms = Object.create(STBModule.prototype);
STBModuleDataForms.name="ModuleDataForms";

STBModuleDataForms.scriptStep = "ajax.dataforms.step";
STBModuleDataForms.scriptUpdate = "ajax.dataforms.update";


STBModuleDataForms.initActions = function (){
	jQuery(document).on(
		"click",
		".survey-step.completed",
		function(e){ 
			e.preventDefault();

			var el = jQuery(this),
				parent = jQuery(this).closest(".survey-item");

			parent.find(".survey-step.active").removeClass("active");
			el.removeClass("completed");
			
			STBModuleDataForms.loadDataForm(
				el.find(".survey-form") , 
				el.attr("data-code") , 
				el.attr("data-ucode")
			);
		}
	);
}


STBModuleDataForms.initDataForms = function (){
	var form = jQuery(".survey-item:not(.__done)");
	

	form.each(function() {
		var survey	= jQuery(this),
			step	= survey.find(".survey-step").first();


		STBModuleDataForms.loadDataForm(
			step.find(".survey-form") , 
			step.attr("data-code"),
			step.attr("data-ucode")
		);

		survey.addClass("__done");
	});
	
}

STBModuleDataForms.nextStep = function(code) {

	var step = jQuery(".survey-step[data-code='" + code + "']"),
		next = step.next();


	if (next.length > 0 ) {

		step.removeClass("active").addClass("completed");

		STBModuleDataForms.loadDataForm(
			next.find(".survey-form") , 
			next.attr("data-code"),
			next.attr("data-ucode")
		);
	}

}


STBModuleDataForms.loadDataForm = function(container , code , ucode) {

	container.load(
		STBModuleDataForms.scriptStep  + "?code=" + code + "&ucode=" + ucode + "&_LANG=" + jQuery("html").attr("lang"),
		function() {

/*
			container.html(
				STBUtils.bgSchemeReplace(
					container.html(),
					container.parent().hasClass("ic") ? "ic" : "nc"
				)
			);			
*/

			site.runOnContentUpdate();

			container.parent().addClass("active");

			container.parent().next(".completed").removeClass("completed");
		}
	);
}

STBModuleDataForms.runOnReady = function() {
	STBModuleDataForms.initActions();
	STBModuleDataForms.initDataForms();	
}

STBModuleDataForms.runOnContentUpdate = function() {
	STBModuleDataForms.initDataForms();	
}


site.registerModule(STBModuleDataForms);


